/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model.atrfile;

import com.wudsn.tools.base.atari.AtrFile;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.thecartstudio.model.AtrLoader;
import com.wudsn.tools.thecartstudio.model.ImportableMenu;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class AtrFileMenu
extends ImportableMenu {
    private static final String PICONAME_TXT = "PICONAME.TXT";
    private AtrFile atrFile;

    public AtrFileMenu(byte[] content) {
        super(content, "MyPicoDOS or Bootmanager");
        try {
            this.atrFile = AtrFile.createInstance(content);
        }
        catch (AtrFile.AtrException atrException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasMenuEntries() {
        return this.atrFile != null && !this.getLongFileNames().isEmpty();
    }

    @Override
    public int collectMenuEntries(Object owner, ImportableMenu.Collector collector) {
        if (owner == null) {
            throw new IllegalArgumentException("Parameter 'owner' must not be null.");
        }
        if (collector == null) {
            throw new IllegalArgumentException("Parameter 'collector' must not be null.");
        }
        if (this.atrFile == null) {
            return 1;
        }
        List<String> longFileNames = this.getLongFileNames();
        if (longFileNames.isEmpty()) {
            return 3;
        }
        int menuVersion = 0;
        int j = 0;
        while (j < longFileNames.size()) {
            collector.collectMenuEntry(owner, menuVersion, j, longFileNames.get(j));
            ++j;
        }
        return 5;
    }

    public List<AtrLoader.PatchRange> getPatchRanges() {
        ArrayList<AtrLoader.PatchRange> patchRanges = new ArrayList<AtrLoader.PatchRange>();
        try {
            AtrFile atrFile = AtrFile.createInstance(this.content);
            ArrayList<Integer> usedSectors = new ArrayList<Integer>();
            switch (AtrFileMenu.addBootmanagerFileNames(atrFile, null)) {
                case V1: {
                    patchRanges.add(new AtrLoader.PatchRange(0, 285));
                    break;
                }
                case V2: {
                    patchRanges.add(new AtrLoader.PatchRange(0, 289));
                    break;
                }
                default: {
                    if (atrFile.hasDirectory() && atrFile.getFileContent("DOS.SYS", usedSectors) != null) {
                        usedSectors.add(1);
                        usedSectors.add(2);
                        usedSectors.add(3);
                        AtrFileMenu.addPatchedSectors(atrFile, usedSectors, patchRanges);
                        break;
                    }
                    patchRanges.add(new AtrLoader.PatchRange(0, Integer.MAX_VALUE));
                    break;
                }
            }
        }
        catch (AtrFile.AtrException ex) {
            throw new RuntimeException(ex);
        }
        return patchRanges;
    }

    public List<WorkbookEntry.Parameter> getPatchParameters() {
        ArrayList<WorkbookEntry.Parameter> result = new ArrayList<WorkbookEntry.Parameter>();
        switch (AtrFileMenu.addBootmanagerFileNames(this.atrFile, null)) {
            case NONE: {
                break;
            }
            case V1: {
                int offset;
                try {
                    offset = this.atrFile.getSectorStartOffset(364) + 113;
                }
                catch (AtrFile.AtrException ex) {
                    throw new RuntimeException(ex);
                }
                result.add(new WorkbookEntry.Parameter(offset++, 174));
                result.add(new WorkbookEntry.Parameter(offset++, "selected_item_number"));
                int n = ++offset;
                result.add(new WorkbookEntry.Parameter(n, 76));
                int n2 = ++offset;
                result.add(new WorkbookEntry.Parameter(n2, 139));
                int n3 = ++offset;
                ++offset;
                result.add(new WorkbookEntry.Parameter(n3, 9));
                break;
            }
            case V2: {
                int offset;
                try {
                    offset = this.atrFile.getSectorStartOffset(364) + 187;
                }
                catch (AtrFile.AtrException ex) {
                    throw new RuntimeException(ex);
                }
                result.add(new WorkbookEntry.Parameter(offset++, 174));
                result.add(new WorkbookEntry.Parameter(offset++, "selected_item_number"));
                int n = ++offset;
                result.add(new WorkbookEntry.Parameter(n, 76));
                int n4 = ++offset;
                result.add(new WorkbookEntry.Parameter(n4, 88));
                int n5 = ++offset;
                ++offset;
                result.add(new WorkbookEntry.Parameter(n5, 9));
            }
        }
        return result;
    }

    private static void addPatchedSectors(AtrFile atrFile, List<Integer> usedSectors, List<AtrLoader.PatchRange> patchRanges) {
        if (atrFile == null) {
            throw new IllegalArgumentException("Parameter 'atrFile' must not be null.");
        }
        if (usedSectors == null) {
            throw new IllegalArgumentException("Parameter 'usedSectors' must not be null.");
        }
        if (patchRanges == null) {
            throw new IllegalArgumentException("Parameter 'patchRanges' must not be null.");
        }
        for (Integer sector : usedSectors) {
            try {
                int startOffset = atrFile.getSectorStartOffset(sector);
                int sectorSize = atrFile.getSectorSize(sector);
                patchRanges.add(new AtrLoader.PatchRange(startOffset, startOffset + sectorSize - 1));
            }
            catch (AtrFile.AtrException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private List<String> getLongFileNames() {
        if (this.atrFile == null) {
            throw new IllegalStateException("Field 'atrFile' must not be null.");
        }
        ArrayList<String> result = new ArrayList<String>();
        AtrFileMenu.addPicoNames(this.atrFile, result);
        AtrFileMenu.addBootmanagerFileNames(this.atrFile, result);
        return result;
    }

    private static BootManagerType addBootmanagerFileNames(AtrFile atrFile, List<String> fileNames) {
        BootManagerType result;
        block12: {
            if (atrFile == null) {
                throw new IllegalArgumentException("Parameter 'atrFile' must not be null.");
            }
            result = BootManagerType.NONE;
            try {
                byte[] bootManagerSector = atrFile.getSector(365);
                if (AtrFileMenu.containsStringAt(bootManagerSector, 79, "Bootmanager (c)1996 by Mike Langer")) {
                    result = BootManagerType.V1;
                } else if (AtrFileMenu.containsStringAt(bootManagerSector, 64, "Bootmanager (c)1996,2022 by Homesoft")) {
                    result = BootManagerType.V2;
                }
                if (result == BootManagerType.NONE || fileNames == null) break block12;
                byte[] sectors = atrFile.getSectors(366, 368, result == BootManagerType.V1 ? 128 : 256);
                int offset = 0;
                int line = 0;
                int maxLine = 1 + Math.min(16, atrFile.getDirectory().size());
                int entrySize = 24;
                StringBuilder builder = new StringBuilder();
                while (offset < sectors.length && line < maxLine) {
                    int b = sectors[offset] & 0xFF;
                    if (b != 0 || sectors[offset + 1] != 0) {
                        if (b < 128) {
                            if (b != 127) {
                                builder.setLength(0);
                                int i = 2;
                                while (i < entrySize) {
                                    b = sectors[offset + i] & 0xFF;
                                    char c = ATASCII[b];
                                    builder.append(c);
                                    ++i;
                                }
                                if (line > 0) {
                                    fileNames.add(builder.toString().trim());
                                }
                            }
                            ++line;
                        }
                        offset += entrySize;
                        continue;
                    }
                    break;
                }
            }
            catch (AtrFile.AtrException ex) {
                result = BootManagerType.NONE;
            }
        }
        return result;
    }

    private static boolean containsStringAt(byte[] bootManagerSector, int offset, String identifier) {
        StringBuilder bootString = new StringBuilder(identifier.length());
        int i = 0;
        while (i < identifier.length()) {
            int b = bootManagerSector[offset + i] & 0xFF;
            bootString.append(ATASCII[b]);
            ++i;
        }
        boolean found = identifier.equals(bootString.toString());
        return found;
    }

    private static boolean addPicoNames(AtrFile atrFile, List<String> result) {
        if (atrFile == null) {
            throw new IllegalArgumentException("Parameter 'atrFile' must not be null.");
        }
        try {
            byte[] picoNameFileContent = atrFile.getFileContent(PICONAME_TXT, null);
            if (picoNameFileContent != null) {
                if (result != null) {
                    int count = 0;
                    StringBuilder builder = new StringBuilder();
                    int i = 0;
                    while (i < picoNameFileContent.length) {
                        int b = picoNameFileContent[i] & 0xFF;
                        if (b == 155) {
                            String longFileName;
                            if (count > 0 && StringUtility.isSpecified(longFileName = builder.toString())) {
                                longFileName = longFileName.substring(11);
                                longFileName = longFileName.trim();
                                result.add(longFileName);
                            }
                            builder.setLength(0);
                            ++count;
                        } else {
                            builder.append((char)(b & 0x7F));
                        }
                        ++i;
                    }
                }
                return true;
            }
        }
        catch (AtrFile.AtrException atrException) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        if (args.length == 0) {
            throw new IllegalArgumentException("Parameter 'args' must not contain a file name.");
        }
        String fileName = args[0];
        File inputFile = new File(fileName);
        AtrFileMenu.scanRecursively(inputFile);
    }

    private static void scanRecursively(File inputFile) {
        AtrFileMenu.println("INFO: Scanning '" + inputFile.getAbsolutePath() + "'.");
        if (!inputFile.exists()) {
            AtrFileMenu.println("ERROR: '" + inputFile.getAbsolutePath() + "' does not exist.");
            return;
        }
        File[] files = inputFile.isDirectory() ? inputFile.listFiles() : new File[]{inputFile};
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                AtrFileMenu.scanRecursively(file);
            } else if (file.isFile() && file.getName().toLowerCase().endsWith(".atr")) {
                try {
                    byte[] atrData = FileUtility.readBytes(file, 0x20000000L, true);
                    AtrFileMenu.println(String.valueOf(file.getName()) + ": ");
                    AtrFile atrFile = AtrFile.createInstance(atrData);
                    AtrFileMenu menu = new AtrFileMenu(atrData);
                    AtrFileMenu.println(atrFile.toString());
                    if (atrFile.hasDirectory()) {
                        AtrFileMenu.println(atrFile.getDirectory().toString());
                        List<String> longFileNames = menu.getLongFileNames();
                        AtrFileMenu.println(longFileNames.toString());
                        List<AtrLoader.PatchRange> patchRanges = menu.getPatchRanges();
                        AtrFileMenu.println(patchRanges.toString());
                    }
                    AtrFileMenu.println("");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private static void println(String text) {
        System.out.println(text);
    }

    private static enum BootManagerType {
        NONE,
        V1,
        V2;

    }
}

