/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.common.ASCIIString;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.base.repository.Attribute;
import com.wudsn.tools.thecartstudio.DataTypes;
import com.wudsn.tools.thecartstudio.model.CartridgeMenuType;
import com.wudsn.tools.thecartstudio.model.FlashTargetType;
import com.wudsn.tools.thecartstudio.model.ReservedContentProvider;
import com.wudsn.tools.thecartstudio.model.ReservedContentProviderFactory;
import com.wudsn.tools.thecartstudio.model.WorkbookBank;
import com.wudsn.tools.thecartstudio.model.WorkbookBanksSummary;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookEntryType;
import com.wudsn.tools.thecartstudio.model.WorkbookGenre;
import com.wudsn.tools.thecartstudio.model.WorkbookMenuEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class WorkbookRoot {
    public static final int TITLE_LENGTH = 40;
    public static final ASCIIString TITLE_CHARACTERS = new ASCIIString("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!\"#$%&'()*+,-./:;<=>?@[\\]^_ ");
    public static final int MAX_BANK_COUNT = 65536;
    public static final int MIN_BANK_SIZE = 1024;
    public static final int MAX_BANK_SIZE = 65536;
    public static final int MAX_GENRE_COUNT = 128;
    private String title = "";
    private FlashTargetType flashTargetType;
    private int bankCount;
    private int bankSize;
    private CartridgeType cartridgeType;
    private CartridgeMenuType cartridgeMenuType;
    private int userSpaceSize;
    private transient ReservedContentProviderFactory.MenuContentProvider menuContentProvider = new ReservedContentProviderFactory.MenuContentProvider();
    private transient ReservedContentProviderFactory.MenuEntriesContentProvider menuEntriesContentProvider = new ReservedContentProviderFactory.MenuEntriesContentProvider();
    private transient ReservedContentProviderFactory.MenuStartupContentProvider menuStartupContentProvider = new ReservedContentProviderFactory.MenuStartupContentProvider();
    private transient ReservedContentProviderFactory.CheckSumContentProvider checkSumContentProvider = new ReservedContentProviderFactory.CheckSumContentProvider();
    private transient ReservedContentProviderFactory.UserSpaceContentProvider userSpaceContentProvider = new ReservedContentProviderFactory.UserSpaceContentProvider();
    private transient boolean banksListInitialized = false;
    private transient List<WorkbookBank> banksList = new ArrayList<WorkbookBank>();
    private transient int reservedBanksCount = 0;
    private List<WorkbookGenre> genresList;
    private List<WorkbookGenre> unmodifiableGenresList;
    private List<WorkbookEntry> entriesList;
    private List<WorkbookEntry> unmodifiableEntriesList;
    private transient Map<String, WorkbookEntry> fileEntriesMap;
    private transient int requiredBanksCount;
    private transient List<WorkbookMenuEntry> menuEntriesList;

    WorkbookRoot() {
        this.setFlashTargetType(FlashTargetType.THECART_128MB, CartridgeType.CARTRIDGE_THECART_128M, 0, 0);
        this.cartridgeMenuType = CartridgeMenuType.EXTENDED;
        this.userSpaceSize = 0;
        this.genresList = new ArrayList<WorkbookGenre>();
        this.unmodifiableGenresList = Collections.unmodifiableList(this.genresList);
        this.entriesList = new ArrayList<WorkbookEntry>();
        this.unmodifiableEntriesList = Collections.unmodifiableList(this.entriesList);
        this.fileEntriesMap = new TreeMap<String, WorkbookEntry>();
        this.requiredBanksCount = 0;
        this.menuEntriesList = new ArrayList<WorkbookMenuEntry>();
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        this.title = title.trim();
    }

    public String getTitle() {
        return this.title;
    }

    public FlashTargetType getFlashTargetType() {
        return this.flashTargetType;
    }

    public void setFlashTargetType(FlashTargetType flashTargetType, CartridgeType cartridgeType, int bankCount, int bankSize) {
        if (flashTargetType == null) {
            throw new IllegalArgumentException("Parameter 'flashTargetType' must not be null.");
        }
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeType' must not be null.");
        }
        this.flashTargetType = flashTargetType;
        if (flashTargetType != FlashTargetType.USER_DEFINED) {
            cartridgeType = flashTargetType.getCartridgeType();
            bankCount = flashTargetType.getBankCount();
            bankSize = flashTargetType.getBankSize();
        }
        this.setCartridgeType(cartridgeType);
        if (bankCount < 0) {
            bankCount = 1;
        }
        if (bankCount > 65536) {
            bankCount = 65536;
        }
        this.bankCount = bankCount;
        if ((bankSize &= 0xFFFFFC00) <= 0) {
            bankSize = 8192;
        }
        if (bankSize > 65536) {
            bankSize = 65536;
        }
        this.bankSize = bankSize;
    }

    public int getBankCount() {
        return this.bankCount;
    }

    public int getBankSize() {
        return this.bankSize;
    }

    public int getImageSize() {
        return this.bankCount * this.bankSize;
    }

    public void setCartridgeType(CartridgeType cartridgeType) {
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeType' must not be null.");
        }
        this.cartridgeType = cartridgeType;
    }

    public CartridgeType getCartridgeType() {
        return this.cartridgeType;
    }

    public void setCartridgeMenuType(CartridgeMenuType cartridgeMenuType) {
        if (cartridgeMenuType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeMenuType' must not be null.");
        }
        this.cartridgeMenuType = cartridgeMenuType;
    }

    public CartridgeMenuType getCartridgeMenuType() {
        return this.cartridgeMenuType;
    }

    public int getUserSpaceSize() {
        return this.userSpaceSize;
    }

    public int getUserSpaceAlignmentSize() {
        return Math.max(this.bankSize, this.cartridgeType.getFlashBlockSize());
    }

    public int getUserSpaceBanksCount() {
        return (this.userSpaceSize + this.bankSize - 1) / this.bankSize;
    }

    public void setUserSpaceSize(int userSpaceSize) {
        this.userSpaceSize = userSpaceSize;
    }

    public List<WorkbookGenre> getGenresList() {
        return this.genresList;
    }

    public List<WorkbookGenre> getUnmodifiableGenresList() {
        return this.unmodifiableGenresList;
    }

    public List<String> getSortedGenreNamesList() {
        ArrayList<String> result = new ArrayList<String>(this.genresList.size());
        for (WorkbookGenre genre : this.genresList) {
            result.add(genre.getName());
        }
        Collections.sort(result, StringUtility.CASE_INSENSITIVE_COMPARATOR);
        Collections.unmodifiableList(result);
        return result;
    }

    final List<ReservedContentProvider> getReservedContentProviders() {
        ArrayList<ReservedContentProvider> result = new ArrayList<ReservedContentProvider>(4);
        result.add(this.menuContentProvider);
        result.add(this.menuEntriesContentProvider);
        result.add(this.menuStartupContentProvider);
        result.add(this.checkSumContentProvider);
        result.add(this.userSpaceContentProvider);
        return result;
    }

    final ReservedContentProviderFactory.MenuEntriesContentProvider getMenuEntriesContentProvider() {
        return this.menuEntriesContentProvider;
    }

    public boolean isBanksListInitialized() {
        return this.banksListInitialized;
    }

    final void clearBanksList() {
        this.banksListInitialized = false;
        this.banksList.clear();
        int bankNumber = 0;
        while (bankNumber < this.bankCount) {
            this.banksList.add(new WorkbookBank(bankNumber));
            ++bankNumber;
        }
        this.reservedBanksCount = 0;
    }

    final void setBanksListInitialized(boolean banksListInitialized, int reservedBanksCount) {
        this.banksListInitialized = banksListInitialized;
        this.reservedBanksCount = reservedBanksCount;
    }

    public List<WorkbookBank> getBanksList() {
        return this.banksList;
    }

    public WorkbookBanksSummary getWorkbookBanksSummary() {
        WorkbookBanksSummary result = new WorkbookBanksSummary();
        result.definedBanksCount = this.bankCount;
        result.reservedBanksCount = this.reservedBanksCount;
        result.requiredBanksCount = this.requiredBanksCount;
        return result;
    }

    public WorkbookEntry getEntry(int index) {
        return this.entriesList.get(index);
    }

    public int getEntryCount() {
        return this.entriesList.size();
    }

    final List<WorkbookEntry> getEntriesList() {
        return this.entriesList;
    }

    final WorkbookEntry getEntry(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 'fileName' must not be null.");
        }
        fileName = fileName.toUpperCase();
        return this.fileEntriesMap.get(fileName);
    }

    final void addEntry(int index, WorkbookEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        if (entry.getType() == WorkbookEntryType.FILE_ENTRY) {
            String key = entry.getFileName().toUpperCase();
            if (this.fileEntriesMap.containsKey(key)) {
                throw new RuntimeException("Entry with file name '" + key + "' is already present.");
            }
            this.fileEntriesMap.put(key, entry);
        }
        this.entriesList.add(index, entry);
        this.requiredBanksCount += entry.getRequiredBanksCount();
    }

    final WorkbookEntry removeEntry(int index) {
        WorkbookEntry result = this.entriesList.remove(index);
        this.requiredBanksCount -= result.getRequiredBanksCount();
        if (result.getType() == WorkbookEntryType.FILE_ENTRY) {
            String key = result.getFileName().toUpperCase();
            this.fileEntriesMap.remove(key);
        }
        return result;
    }

    public List<WorkbookEntry> getUnmodifiableEntriesList() {
        return this.unmodifiableEntriesList;
    }

    public List<WorkbookMenuEntry> getMenuEntriesList() {
        return this.menuEntriesList;
    }

    public WorkbookRoot createCopy() {
        WorkbookRoot result = new WorkbookRoot();
        result.title = this.title;
        result.flashTargetType = this.flashTargetType;
        result.cartridgeType = this.cartridgeType;
        result.bankCount = this.bankCount;
        result.bankSize = this.bankSize;
        result.cartridgeMenuType = this.cartridgeMenuType;
        result.userSpaceSize = this.userSpaceSize;
        IdentityHashMap<WorkbookEntry, WorkbookEntry> entryMap = new IdentityHashMap<WorkbookEntry, WorkbookEntry>();
        for (WorkbookEntry entry : this.unmodifiableEntriesList) {
            WorkbookEntry copy = entry.createCopy();
            entryMap.put(entry, copy);
            result.entriesList.add(entry.createCopy());
        }
        IdentityHashMap<WorkbookGenre, WorkbookGenre> genreMap = new IdentityHashMap<WorkbookGenre, WorkbookGenre>();
        for (WorkbookGenre genre : this.unmodifiableGenresList) {
            WorkbookGenre copy = genre.createCopy();
            genreMap.put(genre, copy);
            result.genresList.add(genre.createCopy());
        }
        return result;
    }

    public boolean contentStructureEquals(WorkbookRoot other) {
        if (other == null) {
            return false;
        }
        if (!other.flashTargetType.equals(this.flashTargetType)) {
            return false;
        }
        if (!other.cartridgeType.equals(this.cartridgeType)) {
            return false;
        }
        if (other.bankCount != this.bankCount) {
            return false;
        }
        if (other.bankSize != this.bankSize) {
            return false;
        }
        if (!other.cartridgeMenuType.equals(this.cartridgeMenuType)) {
            return false;
        }
        return other.userSpaceSize == this.userSpaceSize;
    }

    public boolean contentEquals(WorkbookRoot other) {
        if (other == null) {
            return false;
        }
        if (!other.title.equals(this.title)) {
            return false;
        }
        if (!this.contentStructureEquals(other)) {
            return false;
        }
        if (other.unmodifiableGenresList.size() != this.unmodifiableGenresList.size()) {
            return false;
        }
        int i = 0;
        while (i < other.unmodifiableGenresList.size()) {
            if (!other.unmodifiableGenresList.get(i).equals(this.unmodifiableGenresList.get(i))) {
                return false;
            }
            ++i;
        }
        if (other.unmodifiableEntriesList.size() != this.unmodifiableEntriesList.size()) {
            return false;
        }
        i = 0;
        while (i < other.unmodifiableEntriesList.size()) {
            if (!other.unmodifiableEntriesList.get(i).equals(this.unmodifiableEntriesList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    final void serialize(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 'element' must not be null.");
        }
        Attributes.TITLE.serializeString(element, this.title);
        Attributes.FLASH_TARGET_TYPE.serializeValueSet(element, this.flashTargetType);
        Attributes.BANK_COUNT.serializeInteger(element, this.bankCount);
        Attributes.BANK_SIZE.serializeInteger(element, this.bankSize);
        Attributes.CARTRDIGE_TYPE.serializeValueSet(element, this.cartridgeType);
        Attributes.CARTRDIGE_MENU_TYPE.serializeValueSet(element, this.cartridgeMenuType);
        Attributes.USER_SPACE_SIZE.serializeInteger(element, this.userSpaceSize);
    }

    final void deserialize(org.xml.sax.Attributes attributes) throws SAXException {
        CartridgeType cartridgeType;
        FlashTargetType flashTargetType;
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
        }
        String value = Attributes.TITLE.deserializeString(attributes);
        if (value != null) {
            this.title = value;
        }
        if ((flashTargetType = Attributes.FLASH_TARGET_TYPE.deserializeValueSet(attributes, FlashTargetType.class)) == null) {
            flashTargetType = this.flashTargetType;
        }
        if ((cartridgeType = Attributes.CARTRDIGE_TYPE.deserializeValueSet(attributes, CartridgeType.class)) == null) {
            cartridgeType = this.cartridgeType;
        }
        int bankCount = Attributes.BANK_COUNT.deserializeInteger(attributes);
        int bankSize = Attributes.BANK_SIZE.deserializeInteger(attributes);
        this.setFlashTargetType(flashTargetType, cartridgeType, bankCount, bankSize);
        this.cartridgeMenuType = Attributes.CARTRDIGE_MENU_TYPE.deserializeValueSet(attributes, CartridgeMenuType.class);
        this.userSpaceSize = Attributes.USER_SPACE_SIZE.deserializeInteger(attributes);
    }

    public String toString() {
        return "title=" + this.title + " flashTargetType=" + this.flashTargetType + " bankCount=" + this.bankCount + " bankSize=" + this.bankSize + " cartridgeMenuType=" + this.cartridgeMenuType + " userSpaceSize=" + this.userSpaceSize + " genresList=" + this.unmodifiableGenresList + " entriesList=" + this.unmodifiableEntriesList;
    }

    public static final class Attributes {
        public static final String ELEMENT_NAME = "workbook";
        public static final Attribute TITLE = new Attribute("title", DataTypes.WorkbookRoot_Title);
        public static final Attribute FLASH_TARGET_TYPE = new Attribute("flashTargetType", DataTypes.WorkbookRoot_FlashTargetType);
        public static final Attribute BANK_COUNT = new Attribute("bankCount", DataTypes.WorkbookRoot_BankCount);
        public static final Attribute BANK_SIZE = new Attribute("bankSize", DataTypes.WorkbookRoot_BankSize);
        public static final Attribute CARTRDIGE_TYPE = new Attribute("cartridgeType", DataTypes.WorkbookRoot_CartridgeType);
        public static final Attribute CARTRDIGE_MENU_TYPE = new Attribute("cartridgeMenuType", DataTypes.WorkbookRoot_CartridgeMenuType);
        public static final Attribute USER_SPACE_SIZE = new Attribute("userSpaceSize", DataTypes.WorkbookRoot_UserSpaceSize);

        private Attributes() {
        }
    }
}

