/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.repository;

import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.base.common.ResourceUtility;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.base.repository.Action;
import com.wudsn.tools.base.repository.DataType;
import com.wudsn.tools.base.repository.Message;
import com.wudsn.tools.base.repository.ValueSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public abstract class NLS {
    private static final String FILE_PATH = "$filePath";
    private static final String FILE_EXTENSION = ".properties";
    private static List<ClassEntry> initializedClasses = new ArrayList<ClassEntry>();
    private static String[] suffixes;

    static {
        NLS.initializeLocale(Locale.getDefault().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeLocale(String locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Parameter 'locale' must not be null.");
        }
        if (StringUtility.isEmpty(locale)) {
            throw new IllegalArgumentException("Parameter 'locale' must not be empty.");
        }
        Class<NLS> clazz = NLS.class;
        synchronized (NLS.class) {
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + locale);
                int lastSeparator = locale.lastIndexOf(95);
                if (lastSeparator == -1) break;
                locale = locale.substring(0, lastSeparator);
            }
            result.add("");
            suffixes = result.toArray(new String[result.size()]);
            for (ClassEntry entry : initializedClasses) {
                NLS.loadProperties(entry);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected NLS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initializeClass(Class<? extends NLS> clazz, Class<?> containerClazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter 'clazz' must not be null.");
        }
        Class<NLS> clazz2 = NLS.class;
        synchronized (NLS.class) {
            ClassEntry entry = new ClassEntry(clazz, containerClazz);
            NLS.loadProperties(entry);
            initializedClasses.add(entry);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void loadProperties(ClassEntry entry) {
        String pathPrefix;
        int MOD_EXPECTED;
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        Class<? extends NLS> clazz = entry.clazz;
        Field[] fieldArray = clazz.getDeclaredFields();
        if ((clazz.getModifiers() & 1) == 0) {
            throw new RuntimeException("Class '" + clazz + "' is not public");
        }
        int length = fieldArray.length;
        HashMap<String, Field> fieldsMap = new HashMap<String, Field>(length);
        int i = 0;
        while (i < length) {
            Field field = fieldArray[i];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            fieldsMap.put(fieldArray[i].getName(), field);
            ++i;
        }
        int MOD_MASK = MOD_EXPECTED = 9;
        if (ValueSet.class.isAssignableFrom(clazz)) {
            if (entry.containerClazz == null) {
                throw new RuntimeException("Class '" + clazz.getName() + "' was registered without the required container class.");
            }
            pathPrefix = entry.containerClazz.getName();
            MOD_EXPECTED |= 0x10;
        } else {
            pathPrefix = entry.clazz.getName();
        }
        pathPrefix = pathPrefix.replace('.', '/');
        MOD_MASK = MOD_EXPECTED | 0x10;
        Properties[] properties = new Properties[suffixes.length];
        boolean error = false;
        boolean found = false;
        int i2 = 0;
        while (i2 < suffixes.length) {
            String specificPath = String.valueOf(pathPrefix) + suffixes[i2] + FILE_EXTENSION;
            byte[] input = ResourceUtility.loadResourceAsByteArray(specificPath);
            if (input != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
                try {
                    properties[i2] = new Properties();
                    properties[i2].load(inputStream);
                    properties[i2].put(FILE_PATH, specificPath);
                    found = true;
                }
                catch (IOException ex) {
                    Log.logError("Cannot load resource '{0}'.", new Object[]{specificPath}, ex);
                    error = true;
                }
            }
            ++i2;
        }
        if (!found) {
            Log.logError("No resources for prefix '" + pathPrefix + "' found in the classpath. Make sure there are no folder names with '!' characters involved.", null, null);
            error = true;
        } else {
            clazz = entry.clazz;
            Field[] fieldArray2 = fieldArray;
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                block36: {
                    Field field = fieldArray2[n2];
                    String prefix = field.getName();
                    if ((field.getModifiers() & MOD_MASK) == MOD_EXPECTED) {
                        Object objectValue = null;
                        try {
                            if (field.getType() == String.class) {
                                String text = NLS.getString(properties, prefix, "", true);
                                objectValue = text;
                            } else if (field.getType() == Action.class) {
                                String label = NLS.getString(properties, prefix, ".label", true);
                                String toolTip = NLS.getString(properties, prefix, ".toolTip", false);
                                Action action = (Action)field.get(null);
                                objectValue = action == null ? new Action(label, toolTip, null) : new Action(label, toolTip, action.getAccelerator());
                            } else if (field.getType() == DataType.class) {
                                objectValue = field.get(null);
                                if (objectValue == null) {
                                    throw new RuntimeException("No data type instance in field '" + field + "'.");
                                }
                                DataType dataType = (DataType)objectValue;
                                String label = NLS.getString(properties, prefix, ".label", true);
                                String toolTip = NLS.getString(properties, prefix, ".toolTip", false);
                                dataType.setTexts(label, toolTip);
                                objectValue = dataType;
                            } else {
                                if (ValueSet.class.isAssignableFrom(field.getType())) {
                                    objectValue = field.get(null);
                                    if (objectValue == null) {
                                        throw new RuntimeException("No value set instance in field '" + field + "'.");
                                    }
                                    ValueSet valueSet = (ValueSet)objectValue;
                                    String idPath = valueSet.getClass().getName().substring(valueSet.getClass().getPackage().getName().length() + 1);
                                    idPath = String.valueOf(idPath) + "_" + valueSet.getId();
                                    String text = NLS.getString(properties, idPath, "", true);
                                    valueSet.setText(text);
                                    break block36;
                                }
                                if (field.getType() == Message.class) {
                                    int severity;
                                    char firstChar = prefix.charAt(0);
                                    switch (firstChar) {
                                        case 'S': {
                                            severity = 1;
                                            break;
                                        }
                                        case 'I': {
                                            severity = 2;
                                            break;
                                        }
                                        case 'E': {
                                            severity = 3;
                                            break;
                                        }
                                        default: {
                                            throw new RuntimeException("Unsupported message type '" + firstChar + "'.");
                                        }
                                    }
                                    String shortText = NLS.getString(properties, prefix, "", true);
                                    objectValue = new Message(prefix, severity, shortText);
                                } else {
                                    throw new RuntimeException("Unsupported field type " + field.getType() + ".");
                                }
                            }
                            field.set(null, objectValue);
                        }
                        catch (Exception ex) {
                            Log.logError("Cannot set value '{0}' for field '{1}' of class '{2}'.", new Object[]{objectValue, field.getName(), clazz.getName()}, ex);
                            error = true;
                        }
                    } else if (!ValueSet.class.isAssignableFrom(clazz)) {
                        Log.logError("Cannot set value for field '{0}' of class '{1}'. Field is not public static or final.", new Object[]{field.getName(), clazz.getName()}, null);
                        error = true;
                    }
                }
                ++n2;
            }
        }
        if (error) {
            System.exit(-1);
        }
    }

    private static String getString(Properties[] properties, String prefix, String suffix, boolean mandatory) {
        if (properties == null) {
            throw new IllegalArgumentException("Parameter 'properties' must not be null.");
        }
        if (properties.length == 0) {
            throw new IllegalArgumentException("Parameter 'properties' must not be empty.");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 'prefix' must not be null.");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Parameter 'key' must not be null.");
        }
        String result = null;
        int i = 0;
        while (i < properties.length && result == null) {
            String fullKey;
            if (properties[i] != null && (result = properties[i].getProperty(fullKey = String.valueOf(prefix) + suffix)) == null && mandatory) {
                String filePath = properties[i].getProperty(FILE_PATH);
                Log.logError("Property '{0}' not defined in '{1}'.", new Object[]{fullKey, filePath}, null);
            }
            ++i;
        }
        if (result == null) {
            if (mandatory) {
                throw new RuntimeException("No text for mandatory key '" + prefix + suffix + "' in '" + Arrays.toString(properties) + "'.");
            }
            result = "";
        }
        return result;
    }

    public static String getResourcePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 'path' must not be null.");
        }
        int index = path.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("Parameter 'path' must have a file extension.");
        }
        String pathPrefix = path.substring(0, index);
        String fileExtension = path.substring(index);
        String result = null;
        int i = 0;
        while (i < suffixes.length && result == null) {
            String specificPath = String.valueOf(pathPrefix) + suffixes[i] + fileExtension;
            if (ResourceUtility.loadResourceAsByteArray(specificPath) != null) {
                result = specificPath;
            }
            ++i;
        }
        return result;
    }

    private static class ClassEntry {
        public final Class<? extends NLS> clazz;
        public final Class<?> containerClazz;

        public ClassEntry(Class<? extends NLS> clazz, Class<?> containerClazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Parameter 'clazz' must not be null.");
            }
            this.clazz = clazz;
            this.containerClazz = containerClazz;
        }
    }
}

