/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.common;

import com.wudsn.tools.base.Messages;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.common.XMLHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLUtility {
    private XMLUtility() {
    }

    /*
     * Loose catch block
     */
    public static void open(File file, XMLHandler xmlHandler, MessageQueue messageQueue) {
        SAXParser parser;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (xmlHandler == null) {
            throw new IllegalArgumentException("Parameter 'xmlHandler' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        InputStream inputStream = null;
        try {
            inputStream = FileUtility.openInputStream(file);
        }
        catch (CoreException ex) {
            messageQueue.sendMessage(ex.createMessageQueueEntry(file, null));
            return;
        }
        xmlHandler.startOpen(messageQueue);
        if (messageQueue.containsError()) {
            return;
        }
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Cannot create parser.", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Cannot create parser.", ex);
        }
        try {
            try {
                parser.parse(inputStream, (DefaultHandler)xmlHandler);
            }
            catch (SAXParseException ex) {
                messageQueue.sendMessage(file, null, Messages.E218, file.getAbsolutePath(), TextUtility.formatAsDecimal(ex.getLineNumber()), TextUtility.formatAsDecimal(ex.getColumnNumber()));
                try {
                    FileUtility.closeInputStream(file, inputStream);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return;
            }
            catch (SAXException ex) {
                messageQueue.sendMessage(file, null, Messages.E217, file.getAbsolutePath(), ex.getMessage());
                try {
                    FileUtility.closeInputStream(file, inputStream);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return;
            }
            catch (IOException ex) {
                messageQueue.sendMessage(file, null, Messages.E217, file.getAbsolutePath(), ex.getMessage());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    FileUtility.closeInputStream(file, inputStream);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                FileUtility.closeInputStream(file, inputStream);
            }
            catch (CoreException coreException) {}
        }
    }

    private static Document createDocument() {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        Document document = documentBuilder.newDocument();
        return document;
    }

    public static void save(File file, XMLHandler xmlHandler, MessageQueue messageQueue) {
        block22: {
            if (file == null) {
                throw new IllegalArgumentException("Parameter 'file' must not be null.");
            }
            if (xmlHandler == null) {
                throw new IllegalArgumentException("Parameter 'xmlHandler' must not be null.");
            }
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            File folder = file.getParentFile();
            if (!folder.exists()) {
                if (!folder.mkdirs()) {
                    messageQueue.sendMessage(file, null, Messages.E202, folder.getAbsolutePath());
                    return;
                }
            } else if (!folder.isDirectory()) {
                messageQueue.sendMessage(file, null, Messages.E201, folder.getAbsolutePath());
                return;
            }
            Document document = XMLUtility.createDocument();
            xmlHandler.startSave(document, messageQueue);
            if (messageQueue.containsError()) {
                return;
            }
            OutputStream outputStream = null;
            try {
                try {
                    outputStream = FileUtility.openOutputStream(file);
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    try {
                        Transformer transformer = transformerFactory.newTransformer();
                        transformer.setOutputProperty("indent", "yes");
                        DOMSource source = new DOMSource(document);
                        StreamResult result = new StreamResult(outputStream);
                        transformer.transform(source, result);
                    }
                    catch (TransformerException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                catch (CoreException ex) {
                    messageQueue.sendMessage(ex.createMessageQueueEntry(file, null));
                    if (outputStream == null) break block22;
                    try {
                        FileUtility.closeOutputStream(file, outputStream);
                    }
                    catch (CoreException ex2) {
                        messageQueue.sendMessage(ex2.createMessageQueueEntry(file, null));
                    }
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        FileUtility.closeOutputStream(file, outputStream);
                    }
                    catch (CoreException ex) {
                        messageQueue.sendMessage(ex.createMessageQueueEntry(file, null));
                    }
                }
            }
        }
    }

    public static void copyTo(XMLHandler fromXMLHandler, XMLHandler toXMLHandler) {
        SAXParser parser;
        if (fromXMLHandler == null) {
            throw new IllegalArgumentException("Parameter 'fromXMLHandler' must not be null.");
        }
        if (toXMLHandler == null) {
            throw new IllegalArgumentException("Parameter 'toXMLHandler' must not be null.");
        }
        Document document = XMLUtility.createDocument();
        MessageQueue messageQueue = new MessageQueue();
        fromXMLHandler.startSave(document, messageQueue);
        if (messageQueue.containsError()) {
            return;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        toXMLHandler.startOpen(messageQueue);
        if (messageQueue.containsError()) {
            return;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Cannot create parser.", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Cannot create parser.", ex);
        }
        try {
            parser.parse((InputStream)inputStream, (DefaultHandler)toXMLHandler);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

