/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.common;

import com.wudsn.tools.base.common.ClassPathUtility;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.base.common.StringUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public final class ResourceUtility {
    public static URLStreamHandler createStreamHandler(List<ResourceModifier> resourceModifierList) {
        if (resourceModifierList == null) {
            throw new IllegalArgumentException("Parameter resourceModifierList must not be null.");
        }
        return new ResourceURLStreamHandler(resourceModifierList);
    }

    private ResourceUtility() {
    }

    private static InputStream getInputStream(String path) {
        InputStream result;
        block6: {
            if (path == null) {
                throw new IllegalArgumentException("Parameter 'path' must not be null.");
            }
            ClassLoader loader = ResourceUtility.class.getClassLoader();
            URL url = loader == null ? ClassLoader.getSystemResource(path) : loader.getResource(path);
            result = null;
            try {
                File jarFile;
                if (url == null) break block6;
                try {
                    result = url.openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (result == null && (jarFile = ClassPathUtility.getJarFile()) != null) {
                    result = new JarEntryInputStream(jarFile, path);
                }
            }
            catch (IOException ex) {
                Log.logError("Cannot get input stream for path '{0}'", new Object[]{path}, ex);
            }
        }
        return result;
    }

    public static byte[] loadResourceAsByteArray(String path) {
        ByteArrayOutputStream outputStream;
        block15: {
            if (path == null) {
                throw new IllegalArgumentException("Parameter 'path' must not be null.");
            }
            if (StringUtility.isEmpty(path)) {
                throw new IllegalArgumentException("Parameter 'path' must not be empty.");
            }
            InputStream inputStream = ResourceUtility.getInputStream(path);
            if (inputStream == null) {
                return null;
            }
            outputStream = new ByteArrayOutputStream();
            try {
                try {
                    int actualLength;
                    byte[] buffer = new byte[8192];
                    while ((actualLength = inputStream.read(buffer, 0, buffer.length)) != -1) {
                        outputStream.write(buffer, 0, actualLength);
                    }
                }
                catch (IOException ex) {
                    Log.logError("Cannot load resource '{0}'.", new Object[]{path}, ex);
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return outputStream.toByteArray();
    }

    public static String loadResourceAsString(String path) {
        StringBuilder builder;
        block15: {
            if (path == null) {
                throw new IllegalArgumentException("Parameter 'path' must not be null.");
            }
            if (StringUtility.isEmpty(path)) {
                throw new IllegalArgumentException("Parameter 'path' must not be empty.");
            }
            InputStream inputStream = ResourceUtility.getInputStream(path);
            if (inputStream == null) {
                return null;
            }
            builder = new StringBuilder();
            try {
                try {
                    int actualLength;
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    char[] buffer = new char[8192];
                    while ((actualLength = reader.read(buffer, 0, buffer.length)) != -1) {
                        builder.append(buffer, 0, actualLength);
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Log.logError("Cannot load resource '{0}'.", new Object[]{path}, ex);
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return builder.toString();
    }

    private static final class JarEntryInputStream
    extends InputStream {
        private JarFile jar;
        private InputStream zipEntryInputStream;

        public JarEntryInputStream(File jarFile, String path) throws IOException {
            if (jarFile == null) {
                throw new IllegalArgumentException("Parameter 'jarFile' must not be null.");
            }
            if (path == null) {
                throw new IllegalArgumentException("Parameter 'path' must not be null.");
            }
            this.jar = new JarFile(jarFile);
            ZipEntry zipEntry = this.jar.getEntry(path);
            this.zipEntryInputStream = this.jar.getInputStream(zipEntry);
        }

        @Override
        public int read() throws IOException {
            return this.zipEntryInputStream.read();
        }

        @Override
        public void close() throws IOException {
            try {
                this.zipEntryInputStream.close();
            }
            finally {
                this.jar.close();
            }
        }
    }

    public static interface ResourceModifier {
        public byte[] modifyResource(URL var1, byte[] var2);
    }

    private static final class ResourceURLStreamHandler
    extends URLStreamHandler {
        private List<ResourceModifier> resourceModifierList;

        public ResourceURLStreamHandler(List<ResourceModifier> resourceModifierList) {
            if (resourceModifierList == null) {
                throw new IllegalArgumentException("Parameter resourceModifierList must not be null.");
            }
            this.resourceModifierList = resourceModifierList;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new URLConnection(url){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public String getContentType() {
                    return "text/html";
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    byte[] data = null;
                    if (this.url.getProtocol().equals("jar")) {
                        String jarURIString;
                        String path = this.url.getPath();
                        URI jarURI = ClassPathUtility.getJarURI();
                        if (jarURI != null && path.startsWith(jarURIString = jarURI.toString())) {
                            path = path.substring(jarURIString.length() + 2);
                        }
                        if ((data = ResourceUtility.loadResourceAsByteArray(path)) == null) {
                            throw new IOException("No resource found with path '" + path + "' found.");
                        }
                    } else if (this.url.getProtocol().equals("file")) {
                        try {
                            File file = new File(this.url.toURI());
                            data = FileUtility.readBytes(file, -1L, false);
                        }
                        catch (URISyntaxException jarURI) {
                        }
                        catch (CoreException ex) {
                            throw new IOException(ex.getMessage());
                        }
                    }
                    if (data == null) {
                        data = ("Invalid URL: " + this.url).getBytes();
                    } else {
                        for (ResourceModifier resourceModifier : ResourceURLStreamHandler.this.resourceModifierList) {
                            data = resourceModifier.modifyResource(this.url, data);
                            if (data != null) continue;
                            data = ("Resource modified returned null for URL: " + this.url).getBytes();
                        }
                    }
                    return new ByteArrayInputStream(data);
                }
            };
        }
    }
}

