/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.atari;

public final class ExecutableFile {
    public static boolean isHeader(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Parameter 'data' must not be negative.");
        }
        int i = offset;
        while (i < data.length) {
            if (i + 2 < data.length) {
                if ((data[i] & 0xFF) == 255 || (data[i + 1] & 0xFF) == 255) {
                    i += 2;
                } else if (i == offset) {
                    return false;
                }
            } else {
                return false;
            }
            if (i + 4 < data.length) {
                int endAddress = (data[i + 2] & 0xFF) + 256 * (data[i + 3] & 0xFF);
                int startAddress = (data[i] & 0xFF) + 256 * (data[i + 1] & 0xFF);
                int length = endAddress - startAddress + 1;
                if (length < 1) {
                    return false;
                }
                i = i + 4 + length;
                continue;
            }
            return false;
        }
        return true;
    }
}

