/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.ASCIIString;
import com.wudsn.tools.base.common.ClassPathUtility;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.ResourceUtility;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.model.AtrLoader;
import com.wudsn.tools.thecartstudio.model.CartridgeMenuType;
import com.wudsn.tools.thecartstudio.model.ContentType;
import com.wudsn.tools.thecartstudio.model.DisplayMode;
import com.wudsn.tools.thecartstudio.model.ImportableMenu;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookExport;
import com.wudsn.tools.thecartstudio.model.WorkbookGenre;
import com.wudsn.tools.thecartstudio.model.WorkbookMenuEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class CartridgeMenu {
    private static final String SIMPLE_MENU = "data/cartmenu.rom";
    private static final String EXTENDED_MENU = "data/cartmenu-extended.rom";
    private static final String EXTERNAL_SIMPLE_MENU = "cartmenu.rom";
    private static final String EXTERNAL_EXTENDED_MENU = "cartmenu-extended.rom";
    public static final int MENU_ENTRY_LENGTH = 64;
    private CartridgeMenuType cartridgeMenuType;
    private boolean valid;
    private boolean external;
    private String externalFilePath;
    private String version;
    private byte[] simpleMenuContent;
    private byte[] extendedMenuContent;

    public static CartridgeMenu createInstance(CartridgeMenuType cartridgeMenuType) {
        if (cartridgeMenuType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeMenuType' must not be null.");
        }
        if (cartridgeMenuType.equals(CartridgeMenuType.NONE)) {
            return null;
        }
        CartridgeMenu instance = new CartridgeMenu(cartridgeMenuType);
        return instance;
    }

    private CartridgeMenu(CartridgeMenuType cartridgeMenuType) {
        this.cartridgeMenuType = cartridgeMenuType;
        this.valid = false;
        this.external = false;
        this.externalFilePath = "";
        this.version = "????-??-??";
        boolean simpleMenuValid = false;
        boolean extendedMenuValid = false;
        File jarFolder = ClassPathUtility.getJarFolder();
        byte[] externalSimpleMenuContent = null;
        if (jarFolder != null) {
            try {
                File externalSimpleMenuFile = new File(jarFolder, EXTERNAL_SIMPLE_MENU);
                externalSimpleMenuContent = FileUtility.readBytes(externalSimpleMenuFile, 0x100000L, true);
                this.externalFilePath = externalSimpleMenuFile.getAbsolutePath();
            }
            catch (CoreException externalSimpleMenuFile) {
                // empty catch block
            }
        }
        this.simpleMenuContent = ResourceUtility.loadResourceAsByteArray(SIMPLE_MENU);
        if (externalSimpleMenuContent != null && externalSimpleMenuContent.length == this.simpleMenuContent.length) {
            this.simpleMenuContent = externalSimpleMenuContent;
            this.external = true;
        }
        if (this.simpleMenuContent != null && this.simpleMenuContent.length > 8192) {
            String signature = new String(this.simpleMenuContent, 8160, 16);
            if (signature.startsWith("The!Cart")) {
                this.version = String.valueOf(signature.substring(8, 12)) + "-" + signature.substring(12, 14) + "-" + signature.substring(14, 16);
            }
            simpleMenuValid = true;
        }
        byte[] externalExtendedMenuContent = null;
        if (jarFolder != null) {
            try {
                File externalExtendedMenuFile = new File(jarFolder, EXTERNAL_EXTENDED_MENU);
                externalExtendedMenuContent = FileUtility.readBytes(externalExtendedMenuFile, 0x100000L, true);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.extendedMenuContent = ResourceUtility.loadResourceAsByteArray(EXTENDED_MENU);
        if (externalExtendedMenuContent != null && externalExtendedMenuContent.length > 8192) {
            this.extendedMenuContent = externalExtendedMenuContent;
        }
        if (this.extendedMenuContent != null && this.extendedMenuContent.length > 8192) {
            extendedMenuValid = true;
        }
        if (cartridgeMenuType.equals(CartridgeMenuType.SIMPLE)) {
            this.valid = simpleMenuValid;
        } else if (cartridgeMenuType.equals(CartridgeMenuType.EXTENDED)) {
            this.valid = simpleMenuValid && extendedMenuValid;
        }
    }

    public CartridgeMenuType getCartridgeMenuType() {
        return this.cartridgeMenuType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getExternalFilePath() {
        return this.externalFilePath;
    }

    public String getVersion() {
        return this.version;
    }

    public byte[] getContent(Workbook workbook, WorkbookExport workbookExport, MessageQueue messageQueue) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (workbookExport == null) {
            throw new IllegalArgumentException("Parameter 'workbookExport' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        byte[] content = null;
        if (this.valid) {
            WorkbookRoot root = workbook.getRoot();
            if (root.getCartridgeMenuType() == CartridgeMenuType.SIMPLE) {
                content = this.simpleMenuContent;
            } else if (root.getCartridgeMenuType() == CartridgeMenuType.EXTENDED && (content = this.extendedMenuContent) != null) {
                this.createMenuEntries(workbook, workbookExport, messageQueue);
                if (messageQueue.containsError()) {
                    return null;
                }
                System.arraycopy(this.simpleMenuContent, 0, this.extendedMenuContent, 0, 6144);
                System.arraycopy(this.simpleMenuContent, 8160, this.extendedMenuContent, 8160, 16);
                System.arraycopy(this.extendedMenuContent, 8186, this.simpleMenuContent, 16, 2);
                System.arraycopy(this.simpleMenuContent, 8192, this.extendedMenuContent, 8192, this.simpleMenuContent.length - 8192);
                int startBankNumber = root.getMenuEntriesContentProvider().getStartBankNumber();
                CartridgeMenu.setByte(content, 7936, root.getCartridgeType().getNumericId());
                CartridgeMenu.setWord(content, 7938, root.getBankCount());
                CartridgeMenu.setWord(content, 7940, root.getUnmodifiableGenresList().size() + 1);
                CartridgeMenu.setWord(content, 7942, startBankNumber + 0);
                CartridgeMenu.setWord(content, 7944, root.getMenuEntriesList().size());
                CartridgeMenu.setWord(content, 7946, startBankNumber + 1);
                StringBuffer title = new StringBuffer(root.getTitle());
                int padding = Math.max(0, (WorkbookEntry.TITLE_LENGTH - title.length()) / 2);
                int i = 0;
                while (i < padding) {
                    title.insert(0, ' ');
                    ++i;
                }
                CartridgeMenu.setString(content, 7948, title.toString(), WorkbookEntry.TITLE_LENGTH);
            }
        }
        if (content == null) {
            content = new byte[]{};
        }
        return content;
    }

    private void createMenuEntries(Workbook workbook, WorkbookExport workbookExport, MessageQueue messageQueue) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (workbookExport == null) {
            throw new IllegalArgumentException("Parameter 'workbookExport' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        WorkbookRoot root = workbook.getRoot();
        List<WorkbookEntry> workbookEntries = root.getUnmodifiableEntriesList();
        List<WorkbookMenuEntry> workbookMenuEntries = root.getMenuEntriesList();
        workbookMenuEntries.clear();
        InnerMenuCollector collector = new InnerMenuCollector(workbook);
        int i = 0;
        while (i < workbookEntries.size()) {
            block10: {
                WorkbookEntry workbookEntry;
                block11: {
                    ImportableMenu importableMenu;
                    block9: {
                        workbookEntry = workbookEntries.get(i);
                        importableMenu = null;
                        if (!workbookEntry.getDisplayMode().equals(DisplayMode.MULTIPLE_ENTRIES) || (importableMenu = workbookEntry.getContentType().createImportableMenu(new byte[0])) != null) break block9;
                        messageQueue.sendMessage(workbookEntry, WorkbookEntry.Attributes.DISPLAY_MODE, Messages.E422, workbookEntry.getContentType().toString(), DisplayMode.MULTIPLE_ENTRIES.toString(), ContentType.getImportableMenuList());
                        break block10;
                    }
                    if (importableMenu == null) break block11;
                    byte[] content = workbook.getEntryFileContent(workbookEntry, messageQueue);
                    if (content == null) break block10;
                    importableMenu = workbookEntry.getContentType().createImportableMenu(content);
                    int result = importableMenu.collectMenuEntries(workbookEntry, collector);
                    switch (result) {
                        case 1: 
                        case 2: 
                        case 3: {
                            messageQueue.sendMessage(workbookEntry, WorkbookEntry.Attributes.DISPLAY_MODE, Messages.E423, new String[0]);
                            break block10;
                        }
                        case 4: {
                            messageQueue.sendMessage(workbookEntry, WorkbookEntry.Attributes.DISPLAY_MODE, Messages.I425, importableMenu.getCreatingToolName());
                            break block10;
                        }
                        case 5: {
                            break block10;
                        }
                        default: {
                            throw new RuntimeException("Unsupported result code " + result + ".");
                        }
                    }
                }
                workbookMenuEntries.add(new WorkbookMenuEntry(workbookEntry));
            }
            ++i;
        }
        Collections.sort(workbookMenuEntries);
        workbookExport.setMenuEntries(workbookMenuEntries);
    }

    public static void setMenuEntriesContent(Workbook workbook, byte[] result, MessageQueue messageQueue) {
        int bankSize;
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (result == null) {
            throw new IllegalArgumentException("Parameter 'result' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        Arrays.fill(result, (byte)-1);
        WorkbookRoot root = workbook.getRoot();
        List<Genre> genresList = Genre.setGenreEntriesContent(workbook, result);
        List<WorkbookMenuEntry> workbookMenuEntries = root.getMenuEntriesList();
        int entryOffset = bankSize = workbook.getRoot().getBankSize();
        Genre allGenre = genresList.get(0);
        StringBuilder builder = new StringBuilder(WorkbookEntry.TITLE_LENGTH);
        int i = 0;
        while (i < workbookMenuEntries.size()) {
            WorkbookMenuEntry workbookMenuEntry = workbookMenuEntries.get(i);
            WorkbookEntry workbookEntry = workbookMenuEntry.getWorkbookEntry();
            try {
                int offset = entryOffset + 0;
                CartridgeMenu.setWord(result, offset, i);
                offset = entryOffset + 2;
                CartridgeMenu.setByte(result, offset, workbookEntry.getContentType().getTheCartMode());
                offset = entryOffset + 4;
                CartridgeMenu.setLong(result, offset, workbookEntry.getContentSize());
                offset = entryOffset + 8;
                CartridgeMenu.setWord(result, offset, workbookEntry.getStartBankNumber());
                int initialBankNumber = workbookEntry.getContentType().getCartridgeType().getInitialBankNumber();
                offset = entryOffset + 10;
                CartridgeMenu.setWord(result, offset, initialBankNumber);
                int loaderBaseAddress = AtrLoader.getBaseAddress(workbookEntry);
                offset = entryOffset + 12;
                CartridgeMenu.setWord(result, offset, loaderBaseAddress);
                offset = entryOffset + 14;
                CartridgeMenu.setByte(result, offset, workbookMenuEntry.getSourceType());
                offset = entryOffset + 15;
                CartridgeMenu.setByte(result, offset, workbookMenuEntry.getItemMenuVersion());
                offset = entryOffset + 16;
                CartridgeMenu.setByte(result, offset, workbookMenuEntry.getItemNumber());
                String title = workbookMenuEntry.getTitle().trim();
                offset = entryOffset + 17;
                CartridgeMenu.setByte(result, offset, title.length());
                offset = entryOffset + 18;
                builder.setLength(0);
                builder.append(workbookMenuEntry.getTitle());
                builder.append("                                        ");
                int j = 0;
                while (j < WorkbookEntry.TITLE_LENGTH) {
                    result[offset++] = (byte)builder.charAt(j);
                    ++j;
                }
                offset = entryOffset + 58;
                String genreName = workbookMenuEntry.getWorkbookEntry().getGenreName();
                Genre genre = null;
                if (StringUtility.isSpecified(genreName)) {
                    for (Genre otherGenre : genresList) {
                        if (!otherGenre.getName().equals(genreName)) continue;
                        genre = otherGenre;
                        break;
                    }
                }
                if (genre == null) {
                    genre = allGenre;
                }
                CartridgeMenu.setByte(result, offset, genre.getNumber());
                offset = entryOffset + 59;
                CartridgeMenu.setByte(result, offset, workbookEntry.getFavoriteIndicator() ? 128 : 0);
                if (workbookEntry.getFavoriteIndicator()) {
                    genre.setFavoritesAvailableIndicator();
                    allGenre.setFavoritesAvailableIndicator();
                }
                entryOffset += 64;
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception udring processing of entry " + workbookEntry.getTitle() + " for " + workbookEntry.getFileName(), ex);
            }
            ++i;
        }
    }

    private static void setByte(byte[] content, int offset, int value) {
        if (value > 256) {
            throw new IllegalArgumentException("Value " + value + " is no byte value");
        }
        content[offset] = (byte)(value & 0xFF);
    }

    private static void setWord(byte[] content, int offset, int value) {
        content[offset + 0] = (byte)(value & 0xFF);
        content[offset + 1] = (byte)(value >>> 8 & 0xFF);
    }

    private static void setLong(byte[] content, int offset, long value) {
        content[offset + 0] = (byte)(value & 0xFFL);
        content[offset + 1] = (byte)(value >>> 8 & 0xFFL);
        content[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        content[offset + 3] = (byte)(value >>> 24 & 0xFFL);
    }

    private static void setString(byte[] content, int offset, String value, int length) {
        int i = 0;
        while (i < length) {
            int c = i < value.length() ? (int)value.charAt(i) : 32;
            CartridgeMenu.setByte(content, offset + i, c);
            ++i;
        }
    }

    private static final class Genre {
        public static final int RECORD_SIZE = 4;
        public static final int FLAGS = 0;
        public static final int TEXT_LENGTH = 1;
        public static final int TEXT_OFFSET = 2;
        private static final int MAX_TEXT_LENGTH = 40;
        private final int number;
        private final String name;
        private final byte[] nameBytes;
        private final byte[] result;

        public Genre(int number, String name, int nameOffset, byte[] result) {
            if (name == null) {
                throw new IllegalArgumentException("Parameter name must not be null.");
            }
            if (result == null) {
                throw new IllegalArgumentException("Parameter result must not be null.");
            }
            this.number = number;
            this.name = name;
            this.result = result;
            int offset = number * 4;
            CartridgeMenu.setByte(result, offset + 0, 0);
            String text = name;
            if (text.length() > 40) {
                text = text.substring(0, 40);
            }
            CartridgeMenu.setByte(result, offset + 1, text.length());
            CartridgeMenu.setWord(result, offset + 2, nameOffset);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                buffer.write(ASCIIString.getBytes(text));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            buffer.write(0);
            this.nameBytes = buffer.toByteArray();
            System.arraycopy(this.nameBytes, 0, result, nameOffset, this.nameBytes.length);
        }

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getNameBytes() {
            return this.nameBytes;
        }

        public void setFavoritesAvailableIndicator() {
            int n = this.number * 4 + 0;
            this.result[n] = (byte)(this.result[n] | 0xFFFFFF80);
        }

        public static List<Genre> setGenreEntriesContent(Workbook workbook, byte[] result) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter workbook must not be null.");
            }
            if (result == null) {
                throw new IllegalArgumentException("Parameter result must not be null.");
            }
            ArrayList<WorkbookGenre> workbookGenresList = new ArrayList<WorkbookGenre>(workbook.getRoot().getUnmodifiableGenresList());
            WorkbookGenre allWorkbookGenre = new WorkbookGenre();
            allWorkbookGenre.setName("All");
            workbookGenresList.add(0, allWorkbookGenre);
            int genreCount = workbookGenresList.size();
            int genreNameOffset = genreCount * 4;
            ArrayList<Genre> genresList = new ArrayList<Genre>(genreCount);
            int i = 0;
            while (i < genreCount) {
                WorkbookGenre workbookGenre = (WorkbookGenre)workbookGenresList.get(i);
                Genre genre = new Genre(i, workbookGenre.getName(), genreNameOffset, result);
                genresList.add(genre);
                genreNameOffset += genre.getNameBytes().length;
                ++i;
            }
            return genresList;
        }
    }

    private final class InnerMenuCollector
    implements ImportableMenu.Collector {
        private Workbook workbook;
        private boolean logMenus;
        private boolean logMenuEntries;

        public InnerMenuCollector(Workbook workbook) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            this.workbook = workbook;
            this.logMenus = false;
            this.logMenuEntries = false;
        }

        @Override
        public void collectMenu(Object owner, String info) {
            if (owner == null) {
                throw new IllegalArgumentException("Parameter 'workbookEntry' must not be null.");
            }
            if (info == null) {
                throw new IllegalArgumentException("Parameter 'info' must not be null.");
            }
            WorkbookEntry workbookEntry = (WorkbookEntry)owner;
            if (StringUtility.isEmpty(workbookEntry.getComment())) {
                workbookEntry.setComment(info);
            }
            if (this.logMenus) {
                Log.logInfo("Found importable menu: {0} - '{1}' - '{2}'", new Object[]{workbookEntry.getContentType().toString(), info, workbookEntry.getTitle()});
            }
        }

        @Override
        public final void collectMenuEntry(Object owner, int itemMenuVersion, int itemNumber, String title) {
            if (this.workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            if (owner == null) {
                throw new IllegalArgumentException("Parameter 'workbookEntry' must not be null.");
            }
            if (title == null) {
                throw new IllegalArgumentException("Parameter 'title' must not be null.");
            }
            WorkbookEntry workbookEntry = (WorkbookEntry)owner;
            if (StringUtility.isSpecified(title = title.trim())) {
                if (this.logMenuEntries) {
                    Log.logInfo("Found importable menu entry: '{0}' - '{1}'", new Object[]{workbookEntry.getTitle(), title});
                }
                WorkbookMenuEntry workbookMenuEntry = new WorkbookMenuEntry(workbookEntry);
                workbookMenuEntry.setTitle(title);
                workbookMenuEntry.setSourceType(1);
                workbookMenuEntry.setItemMenuVersion(itemMenuVersion);
                workbookMenuEntry.setItemNumber(itemNumber);
                this.workbook.getRoot().getMenuEntriesList().add(workbookMenuEntry);
            }
        }
    }

    public static final class Offsets {
        public static final int ENTRY_DEFAULT_CARTSTART = 15;
        public static final int CARTCS = 8186;
        public static final int MENU_STUDIO_ROM = 6144;
        public static final int MENU_START_ROM = 7680;
        public static final int MENU_MCB_ROM = 7936;
        public static final int CARTRIDGE_TYPE = 7936;
        public static final int BANK_COUNT = 7938;
        public static final int MENU_GENRES_COUNT = 7940;
        public static final int MENU_GENRES_START_BANK_NUMBER = 7942;
        public static final int MENU_ENTRIES_COUNT = 7944;
        public static final int MENU_ENTRIES_START_BANK_NUMBER = 7946;
        public static final int MENU_TITLE = 7948;
        public static final int CARTMENU_SIGNATURE = 8160;
        public static final int CARTMENU_SIGNATURE_LENGTH = 16;
        public static final int CARTMENU_FIRST_BANK_END = 8192;
        public static final int MENU_ENTRY_NUMBER = 0;
        public static final int MENU_ENTRY_THE_CART_MODE = 2;
        public static final int MENU_ENTRY_CONTENT_SIZE = 4;
        public static final int MENU_ENTRY_START_BANK_NUMBER = 8;
        public static final int MENU_ENTRY_INITIAL_BANK_NUMBER = 10;
        public static final int MENU_ENTRY_LOADER_BASE_ADDRESS = 12;
        public static final int MENU_ENTRY_SOURCE_TYPE = 14;
        public static final int MENU_ENTRY_ITEM_MENU_VERSION = 15;
        public static final int MENU_ENTRY_ITEM_NUMBER = 16;
        public static final int MENU_ENTRY_TITLE_LENGTH = 17;
        public static final int MENU_ENTRY_TITLE = 18;
        public static final int MENU_ENTRY_GENRE_NUMBER = 58;
        public static final int MENU_ENTRY_FAVORITE_INDICATOR = 59;
    }
}

