/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.common.StringUtility;
import java.util.ArrayList;
import java.util.List;

public final class HTMLWriter {
    private static final String BORDER_STYLE = "border-style:solid;border-width:1px;border-collapse:collapse";
    private StringBuilder builder = new StringBuilder();
    private List<String> stack = new ArrayList<String>();
    private boolean tableBorder;

    public void begin(String tag, String attributes) {
        if (tag == null) {
            throw new IllegalArgumentException("Parameter 'tag' must not be null.");
        }
        this.builder.append("<");
        this.builder.append(tag);
        if (attributes != null) {
            this.builder.append(" ");
            this.builder.append(attributes);
        } else if ((tag.equals("th") || tag.equals("td")) && this.tableBorder) {
            this.builder.append(" style=\"border:1px solid\"");
        }
        this.builder.append(">");
        this.stack.add(tag);
    }

    public void end() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("No open tag: " + this.builder);
        }
        String tag = this.stack.remove(this.stack.size() - 1);
        this.builder.append("</");
        this.builder.append(tag);
        this.builder.append(">\n");
        if (tag.equals("table")) {
            this.tableBorder = false;
        }
    }

    public void writeText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.builder.append(text);
    }

    public void writeEncodedText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.writeText(HTMLWriter.getHTMLEncodedString(text));
    }

    public void beginTable() {
        this.beginTable(true);
    }

    public void beginTable(boolean border) {
        this.tableBorder = border;
        this.begin("table", "class=\"sortable\" style=\"text-align:left;" + (this.tableBorder ? BORDER_STYLE : "") + "\"");
    }

    public void beginTableRow() {
        this.begin("tr", null);
    }

    public void writeTableRow(String header, String text) {
        if (header == null) {
            throw new IllegalArgumentException("Parameter 'header' must not be null.");
        }
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.beginTableRow();
        this.writeTableHeader(header);
        this.writeTableCell(text);
        this.end();
    }

    public void writeTableRowCode(String header, String text) {
        this.beginTableRow();
        this.writeTableHeader(header);
        this.begin("td", "style=\"vertical-align:top;font-family:Courier New, Courier, monospace;border:1px solid\"");
        if (text.trim().length() == 0) {
            text = "&nbsp;";
        }
        this.builder.append(text);
        this.end();
        this.end();
    }

    public void writeTableRowCode(String header, char character) {
        String text = "";
        if (character >= ' ') {
            text = Character.toString(character);
        }
        this.writeTableRowCode(header, text);
    }

    public void writeTableHeader(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.begin("th", "style=\"" + (this.tableBorder ? BORDER_STYLE : "") + ";white-space:nowrap;\"");
        this.builder.append(text);
        this.end();
    }

    public void writeTableCell(String text) {
        this.writeTableCell(text, "");
    }

    public void writeTableCell(String text, String style) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        String fullStyle = this.tableBorder ? BORDER_STYLE : "";
        fullStyle = HTMLWriter.appendStyle(fullStyle, style);
        this.begin("td", "style=\"" + fullStyle + "\"");
        this.builder.append(text);
        this.end();
    }

    public void writeEncodedTableCell(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.writeTableCell(HTMLWriter.getHTMLEncodedString(text));
    }

    public void beginList() {
        this.begin("ul", null);
    }

    public void writeListItem(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.begin("li", null);
        this.builder.append(text);
        this.end();
    }

    public String toHTML() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("There are still open tags: " + this.stack + "\n" + this.builder.toString());
        }
        return this.builder.toString();
    }

    public static String getImage(String src, String alt, String text) {
        if (src == null) {
            throw new IllegalArgumentException("Parameter 'src' must not be null.");
        }
        if (alt == null) {
            throw new IllegalArgumentException("Parameter 'alt' must not be null.");
        }
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        return "<img src=\"" + src + "\" alt=\"" + alt + "\"> " + text + "</img>";
    }

    public static String getLink(String href, String text) {
        if (href == null) {
            throw new IllegalArgumentException("Parameter 'href' must not be null.");
        }
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        return "<a href=\"" + href + "\" >" + text + "</a>";
    }

    public static String getString(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("Parameter 'list' must not be null.");
        }
        StringBuilder builder = new StringBuilder();
        int size = list.size();
        int i = 0;
        while (i < size) {
            builder.append(list.get(i));
            if (i < size - 1) {
                builder.append(" ");
            }
            ++i;
        }
        return builder.toString();
    }

    public static String getHTMLEncodedString(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(text.length());
        boolean lastWasBlankChar = false;
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append(" ");
                } else {
                    lastWasBlankChar = true;
                    sb.append(' ');
                }
            } else {
                lastWasBlankChar = false;
                if (c == '\"') {
                    sb.append("\"");
                } else if (c == '&') {
                    sb.append("&");
                } else if (c == '<') {
                    sb.append("<");
                } else if (c == '>') {
                    sb.append(">");
                } else if (c == 'n') {
                    sb.append("n");
                } else if (c == '\'') {
                    sb.append("'");
                } else {
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        sb.append(c);
                    } else {
                        sb.append("&#");
                        sb.append(new Integer(ci).toString());
                        sb.append(';');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static String appendStyle(String style, String additionalStyle) {
        if (StringUtility.isSpecified(style) && !style.endsWith(";") && StringUtility.isSpecified(additionalStyle)) {
            style = String.valueOf(style) + ";";
        }
        return String.valueOf(style) + additionalStyle;
    }
}

