/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.common;

import com.wudsn.tools.base.Texts;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.ResourceUtility;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.gui.Desktop;
import com.wudsn.tools.base.gui.UIManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;

public final class Application {
    public static final String UNKNOWN_VERSION = "????-??-?? ??:??:??";
    private static Application instance;
    private String urlString;
    private String jarFileName;
    private String versionPath;

    private Application() {
    }

    public static void createInstance(String urlString, String jarFileName, Class<?> mainClass) {
        if (urlString == null) {
            throw new IllegalArgumentException("Parameter 'urlString' must not be null.");
        }
        if (jarFileName == null) {
            throw new IllegalArgumentException("Parameter 'jarFileName' must not be null.");
        }
        if (mainClass == null) {
            throw new IllegalArgumentException("Parameter 'mainClass' must not be null.");
        }
        if (instance != null) {
            throw new IllegalStateException("An application with URL '" + urlString + "' was already created.");
        }
        instance = new Application();
        Application.instance.urlString = urlString;
        Application.instance.jarFileName = jarFileName;
        Application.instance.versionPath = String.valueOf(mainClass.getName().replace('.', '/')) + ".version";
        UIManager.init();
    }

    public static Application getInstance() {
        if (instance == null) {
            throw new IllegalStateException("No application instance created.");
        }
        return instance;
    }

    public String getWebVersion() {
        String result;
        block14: {
            URL url;
            result = UNKNOWN_VERSION;
            try {
                url = new URL(this.urlString);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            InputStream urlInputStream = null;
            ZipInputStream zipInputStream = null;
            try {
                ZipEntry zipEntry;
                urlInputStream = url.openStream();
                zipInputStream = new ZipInputStream(urlInputStream);
                ZipEntry jarZipEntry = null;
                while (jarZipEntry == null && (zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (!zipEntry.getName().equals(this.jarFileName)) continue;
                    jarZipEntry = zipEntry;
                }
                if (jarZipEntry != null) {
                    JarInputStream jarInputStream = new JarInputStream(zipInputStream);
                    String versionResource = null;
                    while (versionResource == null && (zipEntry = jarInputStream.getNextEntry()) != null) {
                        if (!zipEntry.getName().equals(this.versionPath)) continue;
                        try {
                            versionResource = FileUtility.readString(this.versionPath, jarInputStream, 0x100000L);
                            result = versionResource.trim();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (IOException ex) {
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (urlInputStream == null) break block14;
                try {
                    urlInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public String getLocalVersion() {
        String result = ResourceUtility.loadResourceAsString(this.versionPath);
        if (result == null) {
            result = UNKNOWN_VERSION;
        }
        result = result.trim();
        return result;
    }

    public void checkForUpdate(final Runnable exitForUpdateRunnable) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Application.this.checkForUpdateSync(exitForUpdateRunnable);
            }
        });
        thread.start();
    }

    void checkForUpdateSync(Runnable exitForUpdateRunnable) {
        String message;
        int dialogResult;
        String localVersion = this.getLocalVersion();
        String webVersion = this.getWebVersion();
        if (!localVersion.equals(UNKNOWN_VERSION) && !webVersion.equals(UNKNOWN_VERSION) && localVersion.compareTo(webVersion) < 0 && (dialogResult = JOptionPane.showConfirmDialog(null, message = TextUtility.format(Texts.UpdateDialog_Text, webVersion), Texts.UpdateDialog_Title, 0)) == 0) {
            Desktop.openBrowser(this.urlString);
            if (exitForUpdateRunnable != null) {
                exitForUpdateRunnable.run();
            }
        }
    }

    public MemoryInfo getMemoryInfo() {
        return new MemoryInfo();
    }

    public final class MemoryInfo {
        public final long totalMemory = Runtime.getRuntime().totalMemory();
        public final long maxMemory = Runtime.getRuntime().maxMemory();
        public final long freeMemory = Runtime.getRuntime().freeMemory();

        MemoryInfo() {
        }

        public String getMaximumMemoryMB() {
            long maximumMemoryMB = this.maxMemory / 0x100000L * 0x100000L;
            String result = TextUtility.formatAsMemorySize(maximumMemoryMB);
            return result;
        }
    }
}

