/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.common;

import com.wudsn.tools.base.common.StringUtility;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;

public final class ASCIIString {
    public static Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    public static Comparator<String> CASE_INSENSITIVE_COMPARATOR = StringUtility.CASE_INSENSITIVE_COMPARATOR;
    private String value;

    public ASCIIString(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static byte[] getBytes(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value2' must not be null.");
        }
        try {
            return value.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported non ASCII characters in '" + value + "'", ex);
        }
    }

    public static byte[] getBytesCentered(String value, int length) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' must not be null.");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Parameter 'line_length' must not be negative. Specified valus is " + length + ".");
        }
        if (value.length() > length) {
            value = value.substring(0, length);
        }
        byte[] result = new byte[length];
        Arrays.fill(result, (byte)32);
        byte[] valueBytes = ASCIIString.getBytes(value);
        int middle = length / 2 - valueBytes.length / 2;
        System.arraycopy(valueBytes, 0, result, middle, valueBytes.length);
        return result;
    }
}

