/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.atari;

import com.wudsn.tools.base.common.StringUtility;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

public final class AtrFile {
    public static final int SECTOR_SIZE_8K = 8192;
    public static final int SECTOR_SIZE_SD = 128;
    public static final int SECTOR_SIZE_DD = 256;
    public static final int HEADER_SIZE = 16;
    public static final int PARAGRAPH_SIZE = 16;
    public static final int MAXIMUM_SIZE = 0x20000000;
    public static final int BOOT_SECTORS = 3;
    public static final int BOOT_SECTORS_SIZE_SD = 384;
    private static final byte[] bootCode;
    private final byte[] data;
    private final int sectorSize;
    private final int sectorCount;
    private final DosVersion dosVersion;

    static {
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[3] = 7;
        byArray[4] = 7;
        byArray[5] = 7;
        byArray[6] = 56;
        byArray[7] = 96;
        bootCode = byArray;
    }

    private AtrFile(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be null.");
        }
        if (!AtrFile.isHeader(data)) {
            throw new IllegalArgumentException("Parameter 'data' is not a valid ATR file");
        }
        this.data = data;
        this.sectorSize = (data[4] & 0xFF) + ((data[5] & 0xFF) << 8);
        int paragraphs = data[2] & 0xFF;
        paragraphs += (data[3] & 0xFF) << 8;
        paragraphs += (data[6] & 0xFF) << 16;
        int dataSize = (paragraphs += (data[7] & 0xFF) << 24) * 16;
        this.sectorCount = data.length >= 384 ? (data.length - 384) / this.sectorSize + 3 : dataSize / 128;
        int vtocSector = 360;
        DosVersion dosVersion = DosVersion.UNKNOWN;
        if (this.sectorCount > vtocSector) {
            int vtocSectorOffset;
            int bootSectorOffset;
            try {
                bootSectorOffset = this.getSectorStartOffset(1);
                vtocSectorOffset = this.getSectorStartOffset(vtocSector);
            }
            catch (AtrException ex) {
                throw new RuntimeException(ex);
            }
            int vtoc0 = data[vtocSectorOffset] & 0xFF;
            int offset1995 = 219;
            int peek1995 = data[offset1995] & 0xFF;
            block1 : switch (vtoc0) {
                case 1: {
                    dosVersion = DosVersion.ATARI_DOS_10;
                    break;
                }
                case 2: {
                    switch (peek1995) {
                        case 170: {
                            dosVersion = DosVersion.ATARI_DOS_20S;
                            break block1;
                        }
                        case 100: {
                            dosVersion = DosVersion.ATARI_DOS_25;
                            break block1;
                        }
                    }
                    if (this.sectorCount == 720) {
                        dosVersion = DosVersion.ATARI_DOS_20S;
                        break;
                    }
                    if (this.sectorCount != 1040) break;
                    dosVersion = DosVersion.ATARI_DOS_25;
                    break;
                }
                default: {
                    byte[] byArray = new byte[6];
                    byArray[0] = 1;
                    byArray[1] = 9;
                    byArray[3] = 50;
                    byArray[4] = 6;
                    byArray[5] = 50;
                    if (this.startsWith(bootSectorOffset, byArray)) {
                        dosVersion = DosVersion.ATARI_DOS_30;
                        break;
                    }
                    byte[] byArray2 = new byte[4];
                    byArray2[0] = 77;
                    byArray2[1] = 3;
                    byArray2[3] = 7;
                    if (this.startsWith(bootSectorOffset, byArray2)) {
                        dosVersion = DosVersion.MYDOS;
                        break;
                    }
                    byte[] byArray3 = new byte[9];
                    byArray3[1] = 3;
                    byArray3[3] = 7;
                    byArray3[4] = 64;
                    byArray3[5] = 7;
                    byArray3[6] = 76;
                    byArray3[7] = -128;
                    byArray3[8] = 7;
                    if (this.startsWith(bootSectorOffset, byArray3)) {
                        dosVersion = DosVersion.SPARTADOS;
                        break;
                    }
                    byte[] byArray4 = new byte[9];
                    byArray4[1] = 3;
                    byArray4[3] = 48;
                    byArray4[4] = -32;
                    byArray4[5] = 7;
                    byArray4[6] = 76;
                    byArray4[7] = -128;
                    byArray4[8] = 48;
                    if (!this.startsWith(bootSectorOffset, byArray4)) break;
                    dosVersion = DosVersion.REALDOS;
                }
            }
        }
        this.dosVersion = dosVersion;
    }

    private boolean startsWith(int offset, byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be null.");
        }
        int i = 0;
        while (i < data.length) {
            if (this.data[offset + i] != data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] createHeader(int dataSize, int sectorSize) {
        if (sectorSize < 128) {
            throw new IllegalArgumentException("Parameter 'sectorSize' must not be less than 128, actual value was " + sectorSize + ".");
        }
        if (sectorSize > 65535) {
            throw new IllegalArgumentException("Parameter 'sectorSize' must not be largen than 65535, actual value was " + sectorSize + ".");
        }
        dataSize = sectorSize == 256 && dataSize >= 384 ? (dataSize - 384 + sectorSize - 1) / sectorSize * sectorSize + 384 : (dataSize + sectorSize - 1) / sectorSize * sectorSize;
        if (dataSize % 16 != 0) {
            throw new IllegalArgumentException("Parameter 'content' has effective size " + dataSize + " which is not a multiple of the paragraph size " + 16 + ".");
        }
        int paragraphs = dataSize / 16;
        byte[] header = new byte[16];
        header[0] = -106;
        header[1] = 2;
        header[4] = (byte)(sectorSize & 0xFF);
        header[5] = (byte)(sectorSize >>> 8 & 0xFF);
        header[2] = (byte)(paragraphs & 0xFF);
        header[3] = (byte)(paragraphs >>> 8 & 0xFF);
        header[6] = (byte)(paragraphs >>> 16 & 0xFF);
        header[7] = (byte)(paragraphs >>> 24 & 0xFF);
        header[8] = 0;
        header[9] = 0;
        header[10] = 0;
        header[11] = 0;
        header[12] = 0;
        header[13] = 0;
        header[14] = 0;
        header[15] = 0;
        return header;
    }

    public static boolean isHeader(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be null.");
        }
        return data.length >= 16 && data[0] == -106 && data[1] == 2;
    }

    public static byte[] createBootSectors() {
        byte[] result = new byte[384];
        System.arraycopy(bootCode, 0, result, 0, bootCode.length);
        return result;
    }

    public static AtrFile createInstance(byte[] data) throws AtrException {
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be null.");
        }
        if (!AtrFile.isHeader(data)) {
            throw new AtrException("Parameter 'data' is not a valid ATR file");
        }
        AtrFile result = new AtrFile(data);
        return result;
    }

    public int getSectorCount() {
        return this.sectorCount;
    }

    public int getSectorSize(int sectorNumber) throws AtrException {
        if (sectorNumber <= 0) {
            throw new AtrException("Parameter 'sectorNumber' must be positive. Specified value is " + sectorNumber + ".");
        }
        if (sectorNumber > this.sectorCount) {
            throw new AtrException("Parameter 'sectorNumber' must be less than the maximum sector " + this.sectorCount + ". Specified value is " + sectorNumber + ".");
        }
        int sectorSize = sectorNumber <= 3 ? 128 : this.sectorSize;
        return sectorSize;
    }

    public int getSectorStartOffset(int sectorNumber) throws AtrException {
        if (sectorNumber <= 0) {
            throw new AtrException("Parameter 'sectorNumber' must be positive. Specified value is " + sectorNumber + ".");
        }
        if (sectorNumber > this.sectorCount) {
            throw new AtrException("Parameter 'sectorNumber' must be less than the maximum sector " + this.sectorCount + ". Specified value is " + sectorNumber + ".");
        }
        int sectorSize = this.getSectorSize(sectorNumber);
        int offset = 16;
        offset = sectorNumber <= 3 ? (offset += (sectorNumber - 1) * 128) : (offset += (sectorNumber - 1 - 3) * sectorSize + 384);
        return offset;
    }

    public byte[] getSector(int sectorNumber) throws AtrException {
        if (sectorNumber <= 0) {
            throw new AtrException("Parameter 'sectorNumber' must be positive. Specified value is " + sectorNumber + ".");
        }
        if (sectorNumber > this.sectorCount) {
            throw new AtrException("Parameter 'sectorNumber' must be less than the maximum sector " + this.sectorCount + ". Specified value is " + sectorNumber + ".");
        }
        int sectorSize = this.getSectorSize(sectorNumber);
        byte[] sector = new byte[sectorSize];
        int offset = this.getSectorStartOffset(sectorNumber);
        System.arraycopy(this.data, offset, sector, 0, sectorSize);
        return sector;
    }

    public byte[] getSectors(int startSectorNumber, int endSectorNumber, int sectorSize) throws AtrException {
        if (startSectorNumber <= 0) {
            throw new AtrException("Parameter 'sectorNumber' must be positive. Specified value is " + startSectorNumber + ".");
        }
        if (startSectorNumber > this.sectorCount) {
            throw new AtrException("Parameter 'sectorNumber' must be less than the maximum sector " + this.sectorCount + ". Specified value is " + startSectorNumber + ".");
        }
        if (endSectorNumber <= 0) {
            throw new AtrException("Parameter 'endSectorNumber' must be positive. Specified value is " + endSectorNumber + ".");
        }
        if (endSectorNumber > this.sectorCount) {
            throw new AtrException("Parameter 'sectorNumber' must be less than the maximum sector " + this.sectorCount + ". Specified value is " + endSectorNumber + ".");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int sectorNumber = startSectorNumber;
        while (sectorNumber <= endSectorNumber) {
            bos.write(this.getSector(sectorNumber), 0, sectorSize);
            ++sectorNumber;
        }
        return bos.toByteArray();
    }

    public boolean hasDirectory() {
        switch (this.dosVersion) {
            case ATARI_DOS_20S: 
            case ATARI_DOS_25: 
            case MYDOS: {
                return true;
            }
        }
        return false;
    }

    public List<DirectoryEntry> getDirectory() throws AtrException {
        return this.getDirectory("");
    }

    public byte[] getFileContent(String fileName, List<Integer> usedSectors) throws AtrException {
        if (StringUtility.isEmpty(fileName)) {
            return null;
        }
        List<DirectoryEntry> entries = this.getDirectory(fileName);
        if (entries.isEmpty()) {
            return null;
        }
        DirectoryEntry directoryEntry = entries.get(0);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int sectorNumber = directoryEntry.getStartSector();
        while (sectorNumber != 0) {
            if (usedSectors != null) {
                usedSectors.add(sectorNumber);
            }
            byte[] sector = this.getSector(sectorNumber);
            int sectorSize = sector.length;
            int bytesUsed = sector[sectorSize - 1] & 0xFF;
            int nextSectorLow = sector[sectorSize - 2] & 0xFF;
            int nextSectorHigh = sector[sectorSize - 3] & 0xFF & 3;
            int nextSector = nextSectorLow + (nextSectorHigh << 8);
            bos.write(sector, 0, bytesUsed);
            sectorNumber = nextSector;
        }
        return bos.toByteArray();
    }

    private List<DirectoryEntry> getDirectory(String fileNameFilter) throws AtrException {
        if (fileNameFilter == null) {
            throw new IllegalArgumentException("Parameter 'fileNameFilter' must not be null.");
        }
        if (!this.hasDirectory()) {
            throw new AtrException("Cannot get directory of unknown or unsupported DOS version " + (Object)((Object)this.dosVersion) + ".");
        }
        ArrayList<DirectoryEntry> result = new ArrayList<DirectoryEntry>();
        int sectorNumber = 361;
        int entryWidth = 16;
        boolean complete = false;
        while (!complete) {
            byte[] sector = this.getSector(sectorNumber);
            int sectorSize = this.getSectorSize(sectorNumber);
            int relevantSectorSize = Math.min(128, sectorSize);
            int offset = 0;
            while (offset < relevantSectorSize && !complete) {
                byte status = sector[offset];
                if (status == 0) {
                    complete = true;
                } else if ((status & 0x80) == 0 && (status & 0x40) != 0) {
                    byte[] fileNameArray = new byte[8];
                    System.arraycopy(sector, offset + 5, fileNameArray, 0, 8);
                    byte[] extensionArray = new byte[3];
                    String fileName = new String(fileNameArray);
                    System.arraycopy(sector, offset + 5 + 8, extensionArray, 0, 3);
                    String extension = new String(extensionArray);
                    String dosFileName = String.valueOf(fileName.trim()) + "." + extension.trim();
                    if (StringUtility.isEmpty(fileNameFilter) || dosFileName.equals(fileNameFilter)) {
                        int startSectorLow = sector[offset + 3] & 0xFF;
                        int startSectorHigh = sector[offset + 4] & 0xFF;
                        int startSector = startSectorLow + (startSectorHigh << 8);
                        DirectoryEntry directoryEntry = new DirectoryEntry(String.valueOf(fileName) + extension, dosFileName, startSector);
                        result.add(directoryEntry);
                    }
                }
                offset += entryWidth;
            }
            offset += sectorSize - relevantSectorSize;
            ++sectorNumber;
        }
        return result;
    }

    public String toString() {
        return "sectorSize=" + this.sectorSize + ", sectorCount=" + this.sectorCount + ", DOS=" + (Object)((Object)this.dosVersion);
    }

    public static final class AtrException
    extends Exception {
        public AtrException(String text) {
            super(text);
        }
    }

    public static final class DirectoryEntry {
        private String directoryFileName;
        private String dosFileName;
        private int startSector;

        DirectoryEntry(String directoryFileName, String dosFileName, int startSector) {
            this.directoryFileName = directoryFileName;
            this.dosFileName = dosFileName;
            this.startSector = startSector;
        }

        public String toString() {
            return "directoryFileName=" + this.directoryFileName + ", dosFileName=" + this.dosFileName + " startSector=" + this.startSector;
        }

        public int getStartSector() {
            return this.startSector;
        }
    }

    public static enum DosVersion {
        UNKNOWN,
        ATARI_DOS_10,
        ATARI_DOS_20S,
        ATARI_DOS_25,
        ATARI_DOS_30,
        MYDOS,
        SPARTADOS,
        REALDOS;

    }
}

