;
;	>> Power Of 2 <<
;
;	A 32-byte intro for the Atari 800 XL (c) 2010-10-16 by JAC!
;
;	Draws Pascal's Triangle Modulo 2 to approximate the Sierpinski triangle.
;	See https://en.wikipedia.org/wiki/Sierpinski_triangle#Properties.
;	Probably one of the few reasonable effects possible in 32 bytes - 6 bytes headers = 26 bytes.
;
;	Inspired by "sierp2", see https://www.pouet.net/prod.php?which=56064.
;	Thanks for that; I love its mathematical beauty.
;
;	This version requires an Atari 800 XL with a Revision C OS to work.
;	Versions for the other OS versions will follow.
;
;	Created using WUDSN IDE. Visit https://www.wudsn.com to increase my hit counter.


	org $2000

	lda #8		;Graphics 8 hires mode
	jsr $ef9c	;Illegal entry point in REV C OS, returns with C=1
loop 	ldy #0		;Current line
 	lda (88),y
 	ror		;Rotate into carry bit
 	eor (88),y
 	ldy #40		;Next line
 	sta (88),y
 	inc 88
 	bne loop
 	inc 89
 	dec $53		;RMARGIN is initialized to 39 by the OS
 	bne loop
; 	bne *		; Save 2 byes
 			;There will be BRK so that the system will stop
 